﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Chapter1__Neapolitan_
{
    class Program
    {
        #region Question 1
        static int FindMax(int[] array)
        {
            int Max = array[0];
            for (int i = 1; i < array.Length; i++)
            {
                if (array[i] > Max)
                    Max = array[i];
            }
            return Max;
        }
        #endregion
        #region Question 2
        static int FindMin(int[] array)
        {
            int Min = array[0];
            for (int i = 1; i < array.Length; i++)
            {
                if (array[i] < Min)
                    Min = array[i];
            }
            return Min;
        }
        #endregion
        #region Question 3
        static void Sub(int[] array)
        {
            for (int i = 0; i < array.Length - 2; i++)
                for (int j = i + 1; j < array.Length - 1; j++)
                    for (int k = j + 1; k < array.Length; k++)
                        Console.WriteLine("{" + array[i] + "," + array[j] + "," + array[k] + "}");
        }
        #endregion
        #region Question 4
        static void BinInsertSort(int[] array)
        {
            for (int i = 0; i < array.Length; i++)
            {
                int Location = BinSearch(array, array[i], 0, i);
                int temp = array[i];
                for (int j = i - 1; j >= Location; j--)
                {
                    array[j + 1] = array[j];
                }
                array[Location] = temp;
            }
        }
        static int BinSearch(int[] array, int key, int left, int right)
        {
            if (left == right)
            {
                return left;
            }
            else
            {
                int middle = left + ((right - left) / 2);
                if (key > array[middle])
                    return BinSearch(array, key, middle + 1, right);
                else if (key < array[middle])
                    return BinSearch(array, key, left, middle);
                else
                    return middle;
            }
        }
        #endregion
        #region Question 5
        static int BMM(int x, int y)
        {
            int Rem;
            while (y != 0)
            {
                Rem = x % y;
                x = y;
                y = Rem;
            }
            return x;
        }
        #endregion
        #region Question 6
        static void FindMaxMin(int[] array, int Low, int High, ref int Min, ref int Max)
        {
            if (Low == High)
            {
                if (array[Low] > Max)
                    Max = array[Low];
                else if (array[Low] < Min)
                    Min = array[Low];
            }
            else if (Low + 1 == High)
            {
                int max, min;
                if (array[Low] > array[High])
                {
                    max = array[Low];
                    min = array[High];
                }
                else
                {
                    min = array[Low];
                    max = array[High];
                }
                if (max > Max)
                    Max = max;
                if (min < Min)
                    Min = min;
            }
            else
            {
                int Middle = (High + Low) / 2;
                FindMaxMin(array, Low, Middle, ref Min, ref Max);
                FindMaxMin(array, Middle + 1, High, ref Min, ref Max);
            }
        }
        #endregion
        #region Question 7
        static bool IsHeap(int[] array)
        {
            // array begin from 1 and root of tree in array[1]
            // this check maxheap
            for (int i = 1; i < array.Length / 2; i++)
                if (array[i] < array[2 * i] || array[i] < array[2 * i + 1])
                    return false;
            return true;
        }
        #endregion
        #region Question 11
        static void InsertSort(int[] array)
        {
            int temp, j;
            for (int i = 1; i < array.Length; i++)
            {
                temp = array[i];
                j = i - 1;
                while (j >= 0 && array[j] > temp)
                {
                    array[j + 1] = array[j];
                    j--;
                }
                array[j + 1] = temp;
            }
        }
        #endregion
        #region Question 12
        static void LinearTime_Sort(int[] array)
        {
            bool[] BooleanArray = new bool[501];
            for (int i = 0; i < array.Length; i++)
            {
                int index = array[i];
                BooleanArray[index] = true;
            }
            for (int i = 0, j = 0; i < BooleanArray.Length; i++)
                if (BooleanArray[i])
                {
                    array[j] = i;
                    j++;
                }
        }
        #endregion
        #region Question 29
        static void MaxPartition(int[] array, out int[] Part1, out int[] Part2)
        {
            int j = 0;
            Part1 = new int[array.Length / 2];
            Part2 = new int[array.Length / 2];
            LinearTime_Sort(array);           // Complexity of this algorithm depend on SortAlgorithm that used
            for (int i = 0; i < Part1.Length; i++)
                Part1[i] = array[j++];
            for (int i = 0; i < Part2.Length; i++)
                Part2[i] = array[j++];
        }
        #endregion
        #region Question 31
        static int Mod(int x, int n, int p)
        {
            if (n == 0)
                return 1;
            if (n % 2 == 0)
            {
                int temp = Mod(x, n / 2, p);
                return (temp * temp) % p;
            }
            else
            {
                return ((x % p) * Mod(x, n - 1, p)) % p;
            }
        }
        #endregion
        #region Question 35
        static void MinPartition(int[] array, out int[] Part1, out int[] Part2)
        {
            int j = 0;
            int k = array.Length - 1;
            Part1 = new int[array.Length / 2];
            Part2 = new int[array.Length / 2];
            LinearTime_Sort(array);           // Complexity of this algorithm depend on SortAlgorithm that used
            for (int i = 0; i < Part1.Length; i+=2)
            {
                Part1[i] = array[j++];
                Part1[i + 1] = array[k--];
            }
            for (int i = 0; i < Part2.Length; i+=2)
            {
                Part2[i] = array[j++];
                Part2[i + 1] = array[k--];
            }
        }

        #endregion
        static void Main(string[] args)
        {
            int[] arr = { 6, 2, 1, 7, 4, 0, 3, 5 };
            Console.WriteLine("-------------------------------------------------------------// 1");
            Console.WriteLine("Max in Array : " + FindMax(arr));
            Console.WriteLine("-------------------------------------------------------------// 2");
            Console.WriteLine("Min in Array : " + FindMin(arr));
            Console.WriteLine("-------------------------------------------------------------// 3");
            Sub(arr);
            Console.WriteLine("-------------------------------------------------------------// 4");
            Print(arr);
            BinInsertSort(arr);
            Print(arr);
            Console.WriteLine("-------------------------------------------------------------// 5");
            Console.WriteLine("BMM is : " + BMM(60, 40));
            Console.WriteLine("-------------------------------------------------------------// 6");
            int Max = arr[0], Min = arr[0];
            FindMaxMin(arr, 0, arr.Length - 1, ref Min, ref Max);
            Console.WriteLine("Max=" + Max + " Min=" + Min);
            Console.WriteLine("-------------------------------------------------------------// 7");
            Console.WriteLine("Is Array of tree is heap ? " + IsHeap(arr));
            Console.WriteLine("-------------------------------------------------------------// 12");
            LinearTime_Sort(arr);
            Print(arr);
            Console.WriteLine("-------------------------------------------------------------// 29");
            int[] p1, p2;
            MaxPartition(arr, out p1, out p2);
            Print(p1);
            Print(p2);
            Console.WriteLine("-------------------------------------------------------------// 31");
            int x = 11, n = 7, p = 13;
            Console.WriteLine("Mod function say " + Mod(x,n,p) + " and answer is " + (Math.Pow(x,n))%p);
            Console.WriteLine("-------------------------------------------------------------// 35");

            Console.ReadKey();
        }
        #region Print
        static void Print(int[] array)
        {
            for (int i = 0; i < array.Length; i++)
                Console.Write(" " + array[i]);
            Console.WriteLine();
        }
        #endregion
    }
}
